package com.handheld.KeyTest;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.TextView;
import android.widget.Toast;

import com.handheld.apiinstructions.R;

public class KeyTestActivity extends Activity {
	TextView tvKeyLeft;
	TextView tvKeyRight;
	TextView tvKeyf1;
	TextView tvKeyf2;
	TextView tvKeyUPWard;
	TextView tvKeyDOWNWard;
	TextView tvKeyLEFTWard;
	TextView tvKeyRIGHTWard;

    private KeyReceiver keyReceiver;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_keytest50);
		initView();
		registerReceiver();
	}

	private void registerReceiver() {
		keyReceiver = new KeyReceiver();
		IntentFilter filter = new IntentFilter();
		filter.addAction("android.rfid.FUN_KEY");
		registerReceiver(keyReceiver , filter);
	}
	private void unregisterReceiver(){
		unregisterReceiver(keyReceiver);
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
		unregisterReceiver();
	}

	private void initView() {
		tvKeyLeft = (TextView) findViewById(R.id.left_key);
		tvKeyRight = (TextView) findViewById(R.id.right_key);
		tvKeyf1 = (TextView) findViewById(R.id.key_f1);
		tvKeyf2 = (TextView) findViewById(R.id.key_f2);
		tvKeyDOWNWard = (TextView) findViewById(R.id.key_downward);
		tvKeyUPWard = (TextView) findViewById(R.id.key_upward);
		tvKeyLEFTWard = (TextView) findViewById(R.id.key_leftward);
		tvKeyRIGHTWard = (TextView) findViewById(R.id.key_rightward);


	}
	int count = 0 ;
	private static Toast toast;
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		Log.e("", "" + keyCode);
		if (toast==null) {
			toast = Toast.makeText(KeyTestActivity.this, "onKeyDown:keyCode = " + keyCode, Toast.LENGTH_SHORT);
		}else {
			toast.setText("onKeyDown:keyCode = " + keyCode);
		}
		toast.show();
		switch (keyCode) {
		case 0://
			break;
		case 19://
			tvKeyUPWard.setBackgroundColor(Color.WHITE);
			break;
			case 20:
				tvKeyDOWNWard.setBackgroundColor(Color.WHITE);
				break;
			case 21:
				tvKeyLEFTWard.setBackgroundColor(Color.WHITE);
				break;
			case 22:
				tvKeyRIGHTWard.setBackgroundColor(Color.WHITE);
				break;
		case 131://SCAN  131
			tvKeyf1.setBackgroundColor(Color.WHITE);
			break;
		case 132://Fn  132
			tvKeyf2.setBackgroundColor(Color.WHITE);

			break;
		case 133://left button 133
			tvKeyLeft.setBackgroundColor(Color.WHITE);
			break;
		case 134://left button 133

			break;
		case 135:// right button 134
			tvKeyRight.setBackgroundColor(Color.WHITE);
			break;


		default:
			break;
		}
		return super.onKeyDown(keyCode, event);
	}
	private class KeyReceiver extends BroadcastReceiver {

		@Override
		public void onReceive(Context context, Intent intent) {
			int keyCode = intent.getIntExtra("keyCode", 0);
			if (keyCode == 0) {//����H941
				keyCode = intent.getIntExtra("keycode", 0);
			}
			boolean keyDown = intent.getBooleanExtra("keydown", false);
			if (keyDown) {
				if (toast == null) {
					toast = Toast.makeText(KeyTestActivity.this, "KeyReceiver:keyCode = " + keyCode, Toast.LENGTH_SHORT);
				} else {
					toast.setText("KeyReceiver:keyCode = " + keyCode);
				}
				toast.show();
				switch (keyCode) {
					case KeyEvent.KEYCODE_F1:
						tvKeyf1.setBackgroundColor(Color.WHITE);
						break;
					case KeyEvent.KEYCODE_F2:
						tvKeyf2.setBackgroundColor(Color.WHITE);
						break;
					case KeyEvent.KEYCODE_F3:
						tvKeyLeft.setBackgroundColor(Color.WHITE);
						break;
					case KeyEvent.KEYCODE_F4:
						break;
					case KeyEvent.KEYCODE_F5:
						tvKeyRight.setBackgroundColor(Color.WHITE);
						break;
				}
			}


		}
	}
}
